
#ifndef __VERSION_H_
#define __VERSION_H_

/**
 * @file: version.h
 *
 * Tento soubor tvori hlavicku k souboru version.c, ktery implementuje
 * rutiny pro urcovani a rozlisovani verzi operacniho systemu.
 */

#include <ntddk.h>


// Ciselne kody jednotlivych verzi Windows
#define VERSION_UNKNOWN                0 // Neznama verze
#define VERSION_W2K                    1 // Windows 2000
#define VERSION_WXP                    2 // Windows XP (x86 a x64)
#define VERSION_W2K3                   3 // Windows Server 2003 (x86)
#define VERSION_VISTA                  4 // Windows Vista (x86 a x64)
#define VERSION_W7                     5 // Windows 7 (x86 a x64)

// Popos jednotlivych rutin najdete u jejich implementace v souboru
// version.c

BOOLEAN CheckedBuild(VOID);
BOOLEAN Windows2000(VOID);
BOOLEAN WindowsXP(VOID);
BOOLEAN WindowsServer2003(VOID);
BOOLEAN WindowsVista(VOID);
BOOLEAN Windows7(VOID);
ULONG GetVersionCode(VOID);

NTSTATUS VersionInit(VOID);
VOID VersionFinit(VOID);


#endif
