
#ifndef __VAD_SECURE_H_
#define __VAD_SECURE_H_

#include <ntddk.h>

typedef struct _MMADDRESS_LLIST {
  ULONG_PTR StartVpn;
  ULONG_PTR EndVpn;
} MMADDRESS_LIST, *PMMADDRESS_LIST;


typedef struct _MMSECURE_ENTRY_W7 {
  MMADDRESS_LIST Range;
  LIST_ENTRY List;
} MMSECURE_ENTRY_W7, *PMMSECURE_ENTRY_W7;


typedef struct _MMSECURE_ENTRY_VISTA {
  MMADDRESS_LIST Range;
  LIST_ENTRY List;
} MMSECURE_ENTRY_VISTA, *PMMSECURE_ENTRY_VISTA;

typedef struct _MMSECURE_ENTRY_W2K3 {
  MMVAD_FLAGS2 VadFlags;
  ULONG_PTR StartingVpn;
  ULONG_PTR EndingVpn;
  LIST_ENTRY List;
} MMSECURE_ENTRY_W2K3, *PMMSECURE_ENTRY_W2K3;

typedef struct _MMSECURE_ENTRY_WXP {
  MMVAD_FLAGS2 VadFlags;
  ULONG_PTR StartingVpn;
  ULONG_PTR EndingVpn;
  LIST_ENTRY List;
} MMSECURE_ENTRY_WXP, *PMMSECURE_ENTRY_WXP;


typedef struct _VAD_SECURE_INFO_ENTRY {
  ULONG64 StartingVpn;
  ULONG64 EndingVpn;
  ULONG64 ReadOnly;
} VAD_SECURE_INFO_ENTRY, *PVAD_SECURE_INFO_ENTRY;

typedef struct _VAD_SECURE_INFO {
  ULONG64 EntryCount;
  VAD_SECURE_INFO_ENTRY Entries[1];
} VAD_SECURE_INFO, *PVAD_SECURE_INFO;



BOOLEAN VSIsVadSecured(PVOID Vad);
ULONG VSGetVadSecuritySize(PVOID Vad);
NTSTATUS VSGetVadSecurity(PVOID Vad, PVAD_SECURE_INFO SecureInfo);

NTSTATUS VSModuleInit(VOID);
VOID VSModuleFinit(VOID);


#endif
