
#ifndef __VAD_LIB_H__
#define __VAD_LIB_H_

/**
 * @file vad-lib.h
 *
 * Hlavickovy soubor vysokourovnove knihovny pro praci s VADy. Zatim dovoluje jenom
 * zjistovat o nich ruzne informace.
 */

#include <ntddk.h>
#include "vad-def.h"
#include "vad-secure.h"

// Hardcoded definice offsetu polozek VadRoot a PhysicalVadRoot ve strukturach
// EPROCESS pro jednotlive verze Windows. Tyto polozky je nutne lokalizovat,
// jelikoz jinak by nebylo mozne zadne VADy ani najit.
#define VAD_ROOT_OFFSET_WXP                            0x11c  // pointer na VAD
#define VAD_ROOT_OFFSET_W2K3                           0x250  // MM_AVL_TABLE
#define VAD_ROOT_OFFSET_VISTA                          0x238  // MM_AVL_TABLE
#define VAD_ROOT_OFFSET_W7                             0x278  // MM_AVL_TABLE

#define VAD_ROOT_OFFSET_W2K3_X64                       0x398 // MM_AVL_TABLE
#define VAD_ROOT_OFFSET_VISTA_X64                      0x380 // MM_AVL_TABLE
#define VAD_ROOT_OFFSET_W7_X64                         0x448 // MM_AVL_TABLE

// Do teto struktury knihovna uklada informace o kazdem VADu. Tato struktura
// je viditelna zvnejsku.
typedef struct _UM_VAD_RECORD {
  ULONG64 Length;
  ULONG64 StartAddress;
  ULONG64 EndAddress;
  ULONG32 StructureType;
  ULONG32 VadType;
  union {
    ULONG64 LongFlags1;
    MMVAD_FLAGS Flags1;
  } u1;

  union {
    ULONG64 LongFlags2;
    MMVAD_FLAGS2 Flags2;
  } u2;

  union {
    ULONG64 LongFlags3;
    MMVAD_FLAGS3 Flags3;
  } u3;

  VAD_SECURE_INFO SecureInfo;
} UM_VAD_RECORD, *PUM_VAD_RECORD;

// Dovoluje zapojit struktury s informacemi o deskriptorech do spojoveho seznamu.
typedef struct _VAD_RECORD {
  LIST_ENTRY Entry;
  UM_VAD_RECORD Record;  
} VAD_RECORD, *PVAD_RECORD;

/**
 * Definice zpetne volane funkce, kterou knihovna vola behem pruchodu AVL stromu
 * s deskriptory.
 *
 * @param Vad Adresa struktury VADu.
 * @param Context Hodnota specifikovana pri volani VadTreeWalk().
 *
 * @return Funkce vraci hodnotu NTSTATUS. Hodnota oznamujici knihovne chybu znamena
 * konec pruchodu stromem (NT_SUCCESS se vyhodnoti na FALSE). V opacnem pripade
 * pruchod stromem pokracuje.
 */
typedef NTSTATUS (*VAD_WALK_ROUTINE)(PVOID Vad, PVOID Context);


// Popis vyznamu jednotlivych rutin naleznete v souboru vad-lib.c v komentarich
// u jejich implementace.

NTSTATUS VadTreeWalk(PEPROCESS Process, VAD_WALK_ROUTINE WalkRoutine, PVOID Context);
NTSTATUS ListProcessVads(PEPROCESS Process, PLIST_ENTRY ListHead);

NTSTATUS VadLibInit(VOID);
VOID VadLibFinit(VOID);


#endif
