
#ifndef __VAD_DEF_WXP_H_
#define __VAD_DEF_WXP_H_

/**
 * @file vad-def-wxp.h
 *
 * Tento soubor obsahuje definice datovych struktur spravce virtualni pameti, ktere
 * maji neco spolecneho s Virtual Address Descriptory. Tyto definice plati na
 * Windows XP x86.
 */

// Prvni skupina priznaku. Vyznam je popsan v souboru vad-def.h
typedef struct _MMVAD_FLAGS_WXP {
  ULONG_PTR CommitCharge : COMMIT_SIZE;
  ULONG_PTR PhysicalMapping : 1;
  ULONG_PTR ImageMap : 1;
  ULONG_PTR UserPhysicalPages : 1;
  ULONG_PTR NoChange : 1;
  ULONG_PTR WriteWatch : 1;
  ULONG_PTR Protection : 5;
  ULONG_PTR LargePages : 1;
  ULONG_PTR MemCommit : 1;
  ULONG_PTR PrivateMemory : 1;
} MMVAD_FLAGS_WXP;

// Druha skupina priznaku. Jejich najdete v souboru vad-def.h
typedef struct _MMVAD_FLAGS2_WXP {
  unsigned FileOffset : 24;
  unsigned SecNoChange : 1;
  unsigned OneSecured : 1;
  unsigned MultipleSecured : 1;
  unsigned ReadOnly : 1;
  unsigned LongVad : 1;
  unsigned ExtendableFile : 1;
  unsigned Inherit : 1;
  unsigned CopyOnWrite : 1;
} MMVAD_FLAGS2_WXP;


// Definice "kratkeho" VADu. Urcen pro alokovanou a rezervovanou privatni pamet.
typedef struct _MMVAD_SHORT_WXP {
  ULONG_PTR StartingVpn;
  ULONG_PTR EndingVpn;
  PVOID Parent;
  PVOID LeftChild;
  PVOID RightChild;
  union {
    ULONG_PTR LongFlags;
    MMVAD_FLAGS_WXP VadFlags;
  } u;
} MMVAD_SHORT_WXP, *PMMVAD_SHORT_WXP;


// Definice stredne velkeho VADu. Urcen prevazne pro pametove mapovane soubory
typedef struct _MMVAD_WXP {
  ULONG_PTR StartingVpn;
  ULONG_PTR EndingVpn;
  PVOID Parent;
  PVOID LeftChild;
  PVOID RightChild;
  union {
    ULONG_PTR LongFlags;
    MMVAD_FLAGS_WXP VadFlags;
  } u;

  PVOID ControlArea;
  PVOID FirstPrototypePte;
  PVOID LastContiguousPte;
  union {
    ULONG LongFlags2;
    MMVAD_FLAGS2_WXP VadFlags2;
  } u2;
} MMVAD_WXP, *PMMVAD_WXP;

// Definice "dlouheho" VADu urceneho pro oblasti, na ktere bylo volano
// MmSecureVirtualMemory
typedef struct _MMVAD_LONG_WXP {
  ULONG_PTR StartingVpn;
  ULONG_PTR EndingVpn;
  PVOID Parent;
  PVOID LeftChild;
  PVOID RightChild;
  union {
    ULONG_PTR LongFlags;
    MMVAD_FLAGS_WXP VadFlags;
  } u;

  PVOID ControlArea;
  PVOID FirstPrototypePte;
  PVOID LastContiguousPte;
  union {
    ULONG LongFlags2;
    MMVAD_FLAGS2_WXP VadFlags2;
  } u2;

  union {
    LIST_ENTRY List;
    LIST_ENTRY Secured;
  } u3;

  union {
    PVOID Banked;
    PVOID ExtendedInfo;
  } u4;
} MMVAD_LONG_WXP, *PMMVAD_LONG_WXP;


#endif
