
#ifndef __VAD_DEF_VISTA_H_
#define __VAD_DEF_VISTA_H_

/**
 * @file vad-def-vista.h
 *
 * Tento soubor obsahuje definice datovych struktur spravce virtualni pameti, ktere
 * maji neco spolecneho s Virtual Address Descriptory. Tyto definice plati na
 * Windows Vista x86 a x64.
 */

// Prvni skupina priznaku. Vyznam je popsan v souboru vad-def.h
typedef struct _MMVAD_FLAGS_VISTA {
  ULONG_PTR CommitCharge : COMMIT_SIZE;
  ULONG_PTR NoChange : 1;
  ULONG_PTR VadType : 3;
  ULONG_PTR MemCommit: 1;
  ULONG_PTR Protection : 5;
  ULONG_PTR Spare : 2;
  ULONG_PTR PrivateMemory : 1;
} MMVAD_FLAGS_VISTA;

// Treti skupina priznaku. Jejich vyznam najdete v souboru vad-def.h
typedef struct _MMVAD_FLAGS3_VISTA {
  ULONG_PTR PreferredNode : 6;
  ULONG_PTR Teb : 1;
  ULONG_PTR Spare : 1;
  ULONG_PTR SequentialAccess : 1;
  ULONG_PTR LastSequentialTrim : 15;
  ULONG_PTR Spare2 : 8;
} MMVAD_FLAGS3_VISTA;

// Druha skupina priznaku. Jejich najdete v souboru vad-def.h
typedef struct _MMVAD_FLAGS2_VISTA {
  unsigned FileOffset : 24;   
  unsigned SecNoChange : 1;    
  unsigned OneSecured : 1;       
  unsigned MultipleSecured : 1; 
  unsigned ReadOnly : 1;    
  unsigned LongVad : 1;     
  unsigned ExtendableFile : 1;
  unsigned Inherit : 1;
  unsigned CopyOnWrite : 1;
} MMVAD_FLAGS2_VISTA;


// Definice stredne velkeho VADu. Urcen prevazne pro pametove mapovane soubory
typedef struct _MMVAD_VISTA {
  MMADDRESS_NODE Node;
  union {
    ULONG_PTR LongFlags;
    MMVAD_FLAGS_VISTA VadFlags;
  } u;

  PVOID PushLock;
  union {
    ULONG_PTR LongFlags3;
    MMVAD_FLAGS3_VISTA VadFlags3;
  } u5;

  union {
    ULONG LongFlags2;
    MMVAD_FLAGS2_VISTA VadFlags2;
  } u2;

  PVOID SubSection;
  PVOID MappedSubSection;
  PVOID FirstPrototypePte;
  PVOID LastContignuousPte;
} MMVAD_VISTA, *PMMVAD_VISTA;

// Definice "kratkeho" VADu. Urcen pro alokovanou a rezervovanou privatni pamet.
typedef struct _MMVAD_SHORT_VISTA {
  MMADDRESS_NODE Node;
  union {
    ULONG_PTR LongFlags;
    MMVAD_FLAGS_VISTA VadFlags;
  } u;

  PVOID PushLock;
  union {
    ULONG_PTR LongFlags3;
    MMVAD_FLAGS3_VISTA VadFlags3;
  } u5;
} MMVAD_SHORT_VISTA, *PMMVAD_SHORT_VISTA;

// Definice "dlouheho" VADu urceneho pro oblasti, na ktere bylo volano
// MmSecureVirtualMemory
typedef struct _MMVAD_LONG_VISTA {
  MMADDRESS_NODE Node;
  union {
    ULONG_PTR LongFlags;
    MMVAD_FLAGS_VISTA VadFlags;
  } u;

  PVOID PushLock;
  union {
    ULONG_PTR LongFlags3;
    MMVAD_FLAGS3_VISTA VadFlags3;
  } u5;

  union {
    ULONG LongFlags2;
    MMVAD_FLAGS2_VISTA VadFlags2;
  } u2;

  PVOID SubSection;
  PVOID FirstPrototypePte;
  PVOID LastContignuousPte;
  union {
    LIST_ENTRY List;
    LIST_ENTRY Secured;
  } u3;

  union {
    PVOID Banked;
    PVOID ExtendedInfo;
  } u4;
} MMVAD_LONG_VISTA, *PMMVAD_LONG_VISTA;


#endif
