Unit Native;

Interface

Uses Windows;


Const
  STATUS_SUCCESS = $00000000;
  STATUS_UNSUCCESSFUL = $C0000001;
  STATUS_ACCESS_VIOLATIONO = $C0000005;
  STATUS_ACCESS_DENIED = $C0000022;
  STATUS_INFO_LENGTH_MISMATCH = $C0000004;

  SystemModuleInformation = 11;

Type
  _SYSTEM_MODULE = Packed Record
    Reserved1 : Cardinal;
    Reserved2 : Cardinal;
    ImageBaseAddress : Pointer;
    ImageSize : Cardinal;
    Flags : Cardinal;
    Id : Word;
    Rank : Word;
    w018 : Word;
    NameOffset : Word;
    Name : Packed Array [0..255] Of AnsiChar;
    end;
  SYSTEM_MODULE = _SYSTEM_MODULE;
  PSYSTEM_MODULE = ^SYSTEM_MODULE;

  _SYSTEM_MODULE_INFORMATION = Packed Record
    ModuleCount : Cardinal;
    Module : Packed Array [0..1] Of SYSTEM_MODULE;
    end;
  SYSTEM_MODULE_INFORMATION = _SYSTEM_MODULE_INFORMATION;
  PSYSTEM_MODULE_INFORMATION = ^SYSTEM_MODULE_INFORMATION;

  _SYSTEM_MODULE_64 = Packed Record
    Reserved1 : Cardinal;
    Reserved2 : Cardinal;
    ImageBaseAddress : Int64;
    ImageSize : Cardinal;
    Flags : Cardinal;
    Id : Word;
    Rank : Word;
    w018 : Word;
    NameOffset : Word;
    Name : Packed Array [0..255] Of AnsiChar;
    end;
  SYSTEM_MODULE_64 = _SYSTEM_MODULE_64;
  PSYSTEM_MODULE_64 = ^SYSTEM_MODULE_64;

  _SYSTEM_MODULE_INFORMATION_64 = Packed Record
    ModuleCount : Cardinal;
    Module : Packed Array [0..1] Of SYSTEM_MODULE_64;
    end;
  SYSTEM_MODULE_INFORMATION_64 = _SYSTEM_MODULE_INFORMATION_64;
  PSYSTEM_MODULE_INFORMATION_64 = ^SYSTEM_MODULE_INFORMATION_64;

Const
  OBJ_INHERIT = $00000002;
  OBJ_PERMANENT = $00000010;
  OBJ_EXCLUSIVE = $00000020;
  OBJ_CASE_INSENSITIVE = $00000040;
  OBJ_OPENIF = $00000080;
  OBJ_OPENLINK = $00000100;
  OBJ_KERNEL_HANDLE = $00000200;
  OBJ_FORCE_ACCESS_CHECK = $00000400;
  OBJ_VALID_ATTRIBUTES = $000007F2;

  DIRECTORY_QUERY = $00000001;
  DIRECTORY_TRAVERSE = $00000002;
  DIRECTORY_CREATE_OBJECT = $00000004;
  DIRECTORY_CREATE_SUBDIRECTORY = $00000008;
  DIRECTORY_ALL_ACCESS = $0000000F;

Type
  HANDLE = Pointer;
  PHANDLE = ^HANDLE;
  NTSTATUS = DWORD;
  ACCESS_MASK = DWORD;
  PACCESS_MASK = ^ACCESS_MASK;
  UNICODE_STRING = Packed Record
    Length : Word;
    MaximumLength : Word;
    Buffer : PWideChar;
    end;
  PUNICODE_STRING = ^UNICODE_STRING;

  ANSI_STRING = Packed Record
    Length : Word;
    MaximumLength : Word;
    Buffer : PAnsiChar;
    end;
  PANSI_STRING = ^ANSI_STRING;

  OBJECT_ATTRIBUTES = Record
    Length : DWORD;
    RootDirectory : HANDLE;
    ObjectName : PUNICODE_STRING;
    Attributes : DWORD;
    SecurityDescriptor : Pointer;
    SecurityQualityOfService : Pointer;
    end;
  POBJECT_ATTRIBUTES = ^OBJECT_ATTRIBUTES;

  OBJDIR_INFORMATION = Packed Record
    ObjectName : UNICODE_STRING;
    ObjectTypeName : UNICODE_STRING;
    end;
  POBJDIR_INFORMATION = ^OBJDIR_INFORMATION;



Procedure InitializeObjectAttributes(ObjectAttributes:POBJECT_ATTRIBUTES;  ObjectName:PUNICODE_STRING; Attributes:DWORD; RootDirectory:HANDLE; SecurityDescriptor:Pointer); StdCall;
Function  NtOpenDirectoryObject(DirectoryObjectHandle:PHANDLE; DesiredAccess:ACCESS_MASK; ObjectAttributes:POBJECT_ATTRIBUTES):NTSTATUS; StdCall;
Function  NtCreateDirectoryObject(DirectoryObjectHandle:PHANDLE; DesiredAccess:ACCESS_MASK; ObjectAttributes:POBJECT_ATTRIBUTES):NTSTATUS; StdCall;
Function  NtQueryDirectoryObject(DirectoryObjectHandle:HANDLE; DirObjInformation:POBJDIR_INFORMATION; BufferLength:DWORD; GetNextIndex:Boolean; IgnoreInputIndex:Boolean; ObjectIndex:PDWORD; DataWritten:PDWORD):NTSTATUS; StdCall;
Function  NtClose(ObjectHandle:HANDLE):NTSTATUS; StdCall;

Function NtQuerySystemInformation(InformationClass:Cardinal; Buffer:Pointer; BufferLength:Cardinal; Var ReturnLength:Cardinal):NTSTATUS; StdCall;

Procedure RtlInitUnicodeString(DestinationString:PUNICODE_STRING; SourceString:PWideChar); StdCall;
Procedure RtlInitAnsiString(DestinationString:PANSI_STRING; SourceString:PAnsiChar); StdCall;
Function  RtlAnsiStringToUnicodeString(DestinationString:PUNICODE_STRING; SourceString:PANSI_STRING; AllocateDestinationString:Boolean):NTSTATUS; StdCall;
Function  RtlUnicodeStringToAnsiString(DestinationString:PANSI_STRING; SourceString:PUNICODE_STRING; AllocateDestinationString:Boolean):NTSTATUS; StdCall;
Procedure RtlFreeUnicodeString(UnicodeString:PUNICODE_STRING); stdCall;
Procedure RtlFreeAnsiString(AnsiString:PANSI_STRING); StdCall;

Implementation


Function  NtOpenDirectoryObject(DirectoryObjectHandle:PHANDLE; DesiredAccess:ACCESS_MASK; ObjectAttributes:POBJECT_ATTRIBUTES):NTSTATUS; StdCall; External 'ntdll.dll';
Function  NtCreateDirectoryObject(DirectoryObjectHandle:PHANDLE; DesiredAccess:ACCESS_MASK; ObjectAttributes:POBJECT_ATTRIBUTES):NTSTATUS; StdCall; External 'ntdll.dll';
Function  NtQueryDirectoryObject(DirectoryObjectHandle:HANDLE; DirObjInformation:POBJDIR_INFORMATION; BufferLength:DWORD; GetNextIndex:Boolean; IgnoreInputIndex:Boolean; ObjectIndex:PDWORD; DataWritten:PDWORD):NTSTATUS; StdCall; External 'ntdll.dll';
Function  NtClose(ObjectHandle:HANDLE):NTSTATUS; StdCall External 'ntdll.dll';

Function NtQuerySystemInformation(InformationClass:Cardinal; Buffer:Pointer; BufferLength:Cardinal; Var ReturnLength:Cardinal):NTSTATUS; StdCall; External 'ntdll.dll';

Procedure RtlInitUnicodeString(DestinationString:PUNICODE_STRING; SourceString:PWideChar); StdCall; External 'ntdll.dll';
Procedure RtlInitAnsiString(DestinationString:PANSI_STRING; SourceString:PAnsiChar); StdCall; external 'ntdll.dll';
Function  RtlAnsiStringToUnicodeString(DestinationString:PUNICODE_STRING; SourceString:PANSI_STRING; AllocateDestinationString:Boolean):NTSTATUS; StdCall; External 'ntdll.dll';
Function  RtlUnicodeStringToAnsiString(DestinationString:PANSI_STRING; SourceString:PUNICODE_STRING; AllocateDestinationString:Boolean):NTSTATUS; StdCall; External 'ntdll.dll';
Procedure RtlFreeUnicodeString(UnicodeString:PUNICODE_STRING); stdCall; External 'ntdll.dll';
Procedure RtlFreeAnsiString(AnsiString:PANSI_STRING); StdCall; External 'ntdll.dll';



Procedure InitializeObjectAttributes(ObjectAttributes:POBJECT_ATTRIBUTES;  ObjectName:PUNICODE_STRING; Attributes:DWORD; RootDirectory:HANDLE; SecurityDescriptor:Pointer); StdCall;
begin
ObjectAttributes.Length:=SizeOf(OBJECT_ATTRIBUTES);
ObjectAttributes.RootDirectory:=RootDirectory;
ObjectAttributes.ObjectName:=ObjectName;
ObjectAttributes.Attributes:=Attributes;
ObjectAttributes.SecurityDescriptor:=SecurityDescriptor;
ObjectAttributes.SecurityQualityOfService:=Nil;
end;

End.

